{DivFix is a utility for reindexing partial DivX AVI movies
Copyright (C) 2000-2003  Csaba Budai

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA}

program DivFix;
{$DEFINE WINDOWS}

uses
{$IFDEF WINDOWS}
  Forms,
{$ELSE}
	QForms,
{$ENDIF}
  SysUtils,
  DivX in 'DivX.pas' {Form1},
  About in 'About.pas' {Form2},
  Parameters in 'Parameters.pas' {Form3},
  DirRequester in 'DirRequester.pas' {Form4};

  Var SearchRec		:	TSearchRec;
      StripIndex	:	Boolean;
      ErrorCheck	:	Boolean;
      i						:	Byte;

{$IFDEF WINDOWS}
{$R *.RES}
{$ELSE}
{$R *.res}
{$ENDIF}

begin
  Application.Initialize;
  Application.CreateForm(TForm1, Form1);
  Application.CreateForm(TForm2, Form2);
  Application.CreateForm(TForm3, Form3);
  Application.CreateForm(TForm4, Form4);
  If ParamCount>0 Then
  Begin
	StripIndex:=False;
  ErrorCheck:=False;
		Form1.Tag:=1;
   	If (ParamStr(1)='/?') Or (ParamStr(1)='-h') Or (ParamStr(1)='-H') Then
    Begin
    	Form3.Button1.Cancel:=True;
    	Form3.Show;
      Form3.Refresh;
      Repeat
      	Application.ProcessMessages;
      Until Not (Form3.Button1.Cancel);
      Exit;
    End;
  	If ParamCount>1 Then
    Begin
    	i:=2;
      Repeat
			 	If (ParamStr(i)='-r') Or (ParamStr(i)='-R') Then StripIndex:=True
        Else If (ParamStr(i)='-e') Or (ParamStr(i)='-E') Then ErrorCheck:=True
        Else If (ParamStr(i)='-o') Or (ParamStr(i)='-O') Then
        Begin
        	Form1.CheckBox1.Checked:=True;
          Form1.CheckBox2.Enabled:=True;
          If (i<ParamCount) And (ParamStr(i+1)[1]<>'-') Then
          Begin
	          Inc(i);
  	        Form1.MaskEdit2.Text:=ParamStr(i);
          End
          Else Form1.MaskEdit2.Text:=ExtractFilePath(ParamStr(1));
        End
        Else If (ParamStr(i)='-c') Or (ParamStr(i)='-C') Then Form1.CheckBox2.Checked:=True
        Else If (ParamStr(i)='-l') Or (ParamStr(i)='-L') Then
        Begin
        	Form1.CheckBox3.Checked:=True;
          If (i<ParamCount) And (ParamStr(i+1)[1]<>'-') Then
          Begin
	          Inc(i);
  	        Form1.MaskEdit3.Text:=ParamStr(i);
          End
          Else Form1.MaskEdit3.Text:='DivFix.log';
        End;
        Inc(i);
      Until i>ParamCount;
     	If FindFirst(ParamStr(1),faAnyFile,SearchRec)=0 Then
      Begin
	      Repeat
        	Form1.ListBox1.Items.Add(ExtractFilePath(ParamStr(1))+SearchRec.Name);
        	Form1.Show;
        	Form1.Refresh;
        Until FindNext(SearchRec)<>0;
        FindClose(SearchRec);
       	If StripIndex Then Form1.Button2Click(nil)
   	    Else If ErrorCheck Then Form1.Button3Click(nil)
        Else Form1.Button1Click(nil);
      End;
    End
    Else
    Begin
     	If FindFirst(ParamStr(1),faAnyFile,SearchRec)=0 Then
      Begin
	 	    Repeat
         	Form1.ListBox1.Items.Add(ExtractFilePath(ParamStr(1))+SearchRec.Name);
	 	    Until FindNext(SearchRec)<>0;
  	    FindClose(SearchRec);
				Form1.Show;
	    	Form1.Refresh;
	      Form1.Button1Click(nil);
      End;
    End;
  End
  Else
  Begin
  	Application.Run;
  End;
end.
