;21.09.90 : 客 ..;
;	;
;	⥪ ப MASM	;
;	;
;;
; Microsoft (R) Macro Assembler	Version 4.0 ;
;;
;
;title MACROLIB.INC
;
;;
;	楤  㭪樨  ࠡ  ࠭
;;
;--------------------------------------------------------------------;
;	樠஢ ᯫ	;
;--------------------------------------------------------------------;
INITDISPLAY	MACRO
	call _INITDISPLAY
	ENDM
;--------------------------------------------------------------------;
;	⠭    X  Y	;
;--------------------------------------------------------------------;
GOTOXY	MACRO	X, Y
	IFNB <X>
	mov	DL, X
	ENDIF
	IFNB <Y>
	mov	DH, Y
	ENDIF
	call _GOTOXY
	ENDM
;--------------------------------------------------------------------;
;  ணࠬ ⠥  (X-DL,Y-DH)  ⨯ (CX) 	;
;--------------------------------------------------------------------;
WHEREXY	MACRO	X, Y, Cursor
	call _WHEREXY
	IFNB <X>
	mov	X, DL
	ENDIF
	IFNB <Y>
	mov	Y, DH
	ENDIF
	IFNB <Cursor>
	mov	CX, Cursor
	ENDIF
	ENDM
;--------------------------------------------------------------------;
;	⠭ 梥 ᨬ  䮭	;
;--------------------------------------------------------------------;
SETCOLOR	MACRO COLOR
	mov	AL, COLOR	;; ⠭
	mov	CS:TextAttr, AL	;; 梥
	ENDM
;--------------------------------------------------------------------;
;	 梥 ᨬ  䮭	;
;--------------------------------------------------------------------;
GETCOLOR	MACRO COLOR
	mov	AL, CS:TextAttr	;; 
	mov	COLOR, AL	;; 梥
	ENDM
;--------------------------------------------------------------------;
;	⠭ ⨯ 	;
;--------------------------------------------------------------------;
SETCURSOR MACRO CURSOR
	mov	AH, 01h
	mov	CX, CURSOR
	int	10h
	ENDM
;;
;	楤  㭪樨  /뢮  ࠭
;;
;--------------------------------------------------------------------;
;	 ணࠬ 뢮  ࠭ ᨬ  AL (CX - . .) ;
;--------------------------------------------------------------------;
WRITEC	MACRO CHAR, Count
	IFNB <CHAR>
	mov	AL, CHAR
	ENDIF
	IFNB <Count>
	mov	CX, Count
	ELSE
	mov	CX, 1
	ENDIF
	call _WRITEC
	ENDM
;--------------------------------------------------------------------;
;	뢥 ப ᨬ	;
;--------------------------------------------------------------------;
WRITES	MACRO STRING
	push DS
	lea	AX, STRING
	push AX
	call _WRITES
	ENDM
;--------------------------------------------------------------------;
; ணࠬ 뢮  ࠭ ப ᨬ  㪠. . .;
;--------------------------------------------------------------------;
WRITESXY	MACRO X, Y, STRING
	IFNB <X>
	mov	DL, X
	ENDIF
	IFNB <Y>
	mov	DH, Y
	ENDIF
	call _GOTOXY
	push DS
	lea	AX, STRING
	push AX
	call _WRITES
	ENDM
;--------------------------------------------------------------------;
;	 ப ᨬ	;
;--------------------------------------------------------------------;
READS	MACRO STRING
	push DS
	lea	AX, STRING
	push AX
	call _READS
	ENDM
;--------------------------------------------------------------------;
;	 ப ᨬ  㪠. . .	;
;--------------------------------------------------------------------;
READSXY	MACRO X, Y, STRING
	IFNB <X>
	mov	DL, X
	ENDIF
	IFNB <Y>
	mov	DH, Y
	ENDIF
	call _GOTOXY
	push DS
	lea	AX, STRING
	push AX
	call _READS
	ENDM
;;
;	楤  㭪樨  ࠡ  ⠫
;;
;--------------------------------------------------------------------;
;	 ணࠬ 뤠 ⥪騩 ⠫	;
;--------------------------------------------------------------------;
GETDIR	MACRO	NAME_DIR
	push DS
	lea	AX, NAME_DIR	;;  ப  67 
	push AX
	call _GETDIR
	ENDM
;--------------------------------------------------------------------;
;	 ணࠬ ⠭ DTA  DS:DX	;
;--------------------------------------------------------------------;
SETDTA	MACRO	NAME_DTA
	push DS
	lea	AX, NAME_DTA
	push AX
	call _SETDTA
	ENDM
;--------------------------------------------------------------------;
;	   ⠫	;
;--------------------------------------------------------------------;
FINDFIRST MACRO	Path, Attr
	push DS
	lea	AX, Path	;;  䠩  ᪠
	push AX
	mov	CX, Attr	;; ਡ 䠩  ᪠
	call _FINDFIRST
	ENDM
;--------------------------------------------------------------------;
;	 ᫥騩  ⠫	;
;--------------------------------------------------------------------;
FINDNEXT	MACRO
	call _FINDNEXT
	ENDM
;;
;	楤  㭪樨  ࠡ  ன
;;
;--------------------------------------------------------------------;
;   (AL- ASCII,AH-᪠-; ᫨ AL=0, AH ᮤ. .);
;--------------------------------------------------------------------;
READKEY	MACRO
	call _READKEY
	ENDM
;--------------------------------------------------------------------;
;	஢ઠ   (᫨  AL=TRUE)	;
;--------------------------------------------------------------------;
PRESKEY	MACRO
	call _PRESKEY
	ENDM
;;
;	楤  㭪樨  ࠡ  
;;
;--------------------------------------------------------------------;
;	஢  <㤠[SI]>,<㤠[DI]>,<᪮쪮>	;
;--------------------------------------------------------------------;
MOVEMEM	MACRO	SOURCE, DEST, Count
	lea	SI, SOURCE
	lea	DI, ES:DEST
	mov	CX, Count
	rep	movsb
	ENDM
;--------------------------------------------------------------------;
;	  <㤠1>,<㤠1>,<᪮쪮>	;
;--------------------------------------------------------------------;
XCHGMEM	MACRO	SOURCE1, SOURCE2, Count
	local NEXT
	sub	BX, BX
	mov	CX, Count
NEXT:
	mov	AL, SOURCE1[BX]
	xchg SOURCE2[BX], AL
	mov	SOURCE1[BX], AL
	inc	BX
	loop NEXT
	ENDM
;;
;	楤  㭪樨  ࠡ  ६묨 ⨯ char
;;
;--------------------------------------------------------------------;
;	 STRING  COUNT ᨬ CHAR	;
;--------------------------------------------------------------------;
FILLCHAR	MACRO	CHAR, STRING, COUNT
	mov	DL, CHAR
	mov	CX, COUNT
	push DS
	lea	AX, STRING
	push AX
	call _FILLCHAR
	ENDM
;;
;	楤  㭪樨  ࠡ  ६묨 ⨯ string
;;
;--------------------------------------------------------------------;
;	頥    ப	;
;--------------------------------------------------------------------;
LEN	MACRO	STRING
	push DS
	lea	AX, STRING
	push AX
	call _LEN
	ENDM
;--------------------------------------------------------------------;
;	१ ஡ ᫥	;
;--------------------------------------------------------------------;
LTRIM	MACRO	STRING_OUT, STRING_IN
	push DS
	lea	AX, STRING_IN
	push AX
	push DS
	lea	AX, STRING_OUT
	push AX
	call _LTRIM
	ENDM
;--------------------------------------------------------------------;
;	१ ஡ ࠢ	;
;--------------------------------------------------------------------;
RTRIM	MACRO	STRING_OUT, STRING_IN
	push DS
	lea	AX, STRING_IN
	push AX
	push DS
	lea	AX, STRING_OUT
	push AX
	call _RTRIM
	ENDM
;--------------------------------------------------------------------;
;	१ ஡ ࠢ  ᫥	;
;--------------------------------------------------------------------;
LRTRIM	MACRO	STRING_OUT, STRING_IN
	LTRIM STRING_OUT, STRING_IN
	RTRIM STRING_OUT, STRING_OUT
	ENDM
;--------------------------------------------------------------------;
;  ப STRING_OUT=STRING_IN1+STRING_IN2(S1=S2+S1);
;--------------------------------------------------------------------;
CONCAT	MACRO	STRING_OUT, STRING_IN1, STRING_IN2
	push DS
	lea	AX, STRING_IN2
	push AX
	push DS
	lea	AX, STRING_IN1
	push AX
	push DS
	lea	AX, STRING_OUT
	push AX
	call _CONCAT
	ENDM
;--------------------------------------------------------------------;
;	 ப  ப <ப>, < 樨>, <᪮쪮>	;
;--------------------------------------------------------------------;
DELETE	MACRO	STRING_OUT, INDEX, COUNT
	mov	DX, INDEX
	mov	CX, COUNT
	push DS
	lea	AX, STRING_OUT
	push AX
	call _DELETE
	ENDM
;--------------------------------------------------------------------;
;	⠢ ᨬ  ப  樨 <ᨬ> <ப> <>	;
;--------------------------------------------------------------------;
INSERT	MACRO	CHAR, STRING_OUT, INDEX
	mov	DL, CHAR
	mov	CX, INDEX
	push DS
	lea	AX, STRING_OUT
	push AX
	call _INSERT
	ENDM
;--------------------------------------------------------------------;
;	᢮ ப STRING_OUT=STRING_IN	;
;--------------------------------------------------------------------;
GIVES	MACRO	STRING_OUT, STRING_IN
	push DS
	lea	AX, STRING_IN
	push AX
	push DS
	lea	AX, STRING_OUT
	push AX
	call _GIVES
	ENDM
;;
;	楤  㭪樨  ࠡ  䠩
;;
;--------------------------------------------------------------------;
;	 䠩	;
;--------------------------------------------------------------------;
OPENF	MACRO	NACCESS, NAMEFILE, FACCESS
	lea	DX, NAMEFILE
	mov	AL, FACCESS
	call _OPENF
	mov	NACCESS, AX	;;  ᫮ 㯠  䠩
	ENDM
;--------------------------------------------------------------------;
;	 䠩	;
;--------------------------------------------------------------------;
CLOSEF	MACRO	NACCESS
	mov	BX, NACCESS
	call _CLOSEF
	ENDM
;--------------------------------------------------------------------;
;	⥭  䠩/ன⢠	;
;--------------------------------------------------------------------;
READF	MACRO	NACCESS, BUFFERF, LENRECNO, LENRESULT
	mov	BX, NACCESS
	push DS
	lea	AX, BUFFERF
	push AX
	mov	CX, LENRECNO
	call _READF
	mov	LENRESULT, AX
	ENDM
;--------------------------------------------------------------------;
;	  䠩/ன⢮	;
;--------------------------------------------------------------------;
WRITEF	MACRO	NACCESS, BUFFERF, LENRECNO, LENRESULT
	mov	BX, NACCESS
	push DS
	lea	AX, BUFFERF
	push AX
	mov	CX, LENRECNO
	call _WRITEF
	mov	LENRESULT, AX
	ENDM
;--------------------------------------------------------------------;
;	 樨  ⥭/	;
;--------------------------------------------------------------------;
SEEKF	MACRO	NACCESS, NRECNO
	mov	BX, NACCESS	;;  ᫮ 㯠  䠩
	mov	CX, word ptr NRECNO+2	;; (CX * 65536) + DX
	mov	DX, word ptr NRECNO	;; Offset ᬥ饭  
	call _SEEKF
	ENDM
;--------------------------------------------------------------------;
;	। ⥪   䠩 (DX * 65536) + AX - 	;
;--------------------------------------------------------------------;
RECNOF	MACRO	NACCESS, NRECNO
	mov	BX, NACCESS	;;  ᫮ 㯠  䠩
	call _RECNOF
	mov	word ptr NRECNO+2, DX	;; (CX * 65536) + DX
	mov	word ptr NRECNO, AX	;; Offset ᬥ饭  
	ENDM
;;
;	楤  㭪樨  ࠡ  ᨢ
;;
;--------------------------------------------------------------------;
;	⠭  ॣ	;
;--------------------------------------------------------------------;
MINDEX	MACRO IReg, Index, Long
	mov	AX, Index
	mov	DX, Long
	mul	DX
	mov	IReg, AX
	ENDM
;;
;	楤  㭪樨  ࠡ  
;;
;--------------------------------------------------------------------;
;	६  	;
;--------------------------------------------------------------------;
SCROLLUP	MACRO NStr, X1, Y1, X2, Y2
	mov	AH, 06h
	mov	AL, NStr
	mov	CL, X1
	mov	CH, Y1
	mov	DL, X2
	mov	DH, Y2
	mov	BH, CS:TextAttr
	int	10h
	ENDM
;--------------------------------------------------------------------;
;	६  	;
;--------------------------------------------------------------------;
SCROLLDN	MACRO NStr, X1, Y1, X2, Y2
	mov	AH, 07h
	mov	AL, NStr
	mov	CL, X1
	mov	CH, Y1
	mov	DL, X2
	mov	DH, Y2
	mov	BH, CS:TextAttr
	int	10h
	ENDM
;;
;	⨫ 楤  㭪樨	;
;;
;--------------------------------------------------------------------;
;	 אַ㣮쭨	(BOX	db	'Ŀ',0 {᫨  9})	;
;--------------------------------------------------------------------;
BOXDRAW	MACRO	X1, Y1, X2, Y2, BOX
	mov	CL, X1
	mov	CH, Y1
	mov	DL, X2
	mov	DH, Y2
	push CX
	push DX
	push DS
	lea	AX, BOX
	push AX
	call _BOXDRAW
	ENDM
;--------------------------------------------------------------------;
;	 ࠭  㪠 न  ६. ⨯ 㪠⥫	;
;--------------------------------------------------------------------;
SAVESCREEN	MACRO	X1, Y1, X2, Y2, SCREEN
	mov	CL, X1
	mov	CH, Y1
	mov	DL, X2
	mov	DH, Y2
	push CX
	push DX
	push DS
	lea	AX, SCREEN
	push AX
	call _SAVESCREEN
	ENDM
;--------------------------------------------------------------------;
; ᯮ ࠭  㪠 न  ६. ⨯ 㪠⥫	;
;--------------------------------------------------------------------;
RESTSCREEN	MACRO	X1, Y1, X2, Y2, SCREEN
	mov	CL, X1
	mov	CH, Y1
	mov	DL, X2
	mov	DH, Y2
	push CX
	push DX
	push DS
	lea	AX, SCREEN
	push AX
	call _RESTSCREEN
	ENDM
;;
;	ᥢ- 砩 ᥫ
;;
;--------------------------------------------------------------------;
;	樠 ᥢ- 砩 ᥫ	;
;--------------------------------------------------------------------;
RANDOMIZE MACRO
	call _RANDOMIZE
	ENDM
;--------------------------------------------------------------------;
;	⢥ ᥢ- 砩 ᥫ	;
;--------------------------------------------------------------------;
RANDOM	MACRO	MAXRANDOM,RANDOMNUMBER
	mov	AX, MAXRANDOM
	call _RANDOM
	mov	RANDOMNUMBER,	AX
	ENDM
;;
;	 ࠡ  "㦥"	;
;;
;--------------------------------------------------------------------;
;	  䠩   㧪  Env	;
;--------------------------------------------------------------------;
PATHEXEC	MACRO PathFile
	push DS
	lea	AX, PathFile
	push AX
	call _PATHEXEC
	ENDM
;;
;	 ࠡ  ⥪	;
;;
;--------------------------------------------------------------------;
;	 祭 ॣ஢  ⥪	(PUSH_REGS <AX,BX>)	;
;--------------------------------------------------------------------;
PUSH_REGS MACRO reg_list
	IRP	reg,<reg_list>
	push reg
	ENDM
	ENDM
;--------------------------------------------------------------------;
;	  ⥪ 祭 ॣ஢	(POP_REGS <BX,AX>)	;
;--------------------------------------------------------------------;
POP_REGS	MACRO reg_list
	IRP	reg,<reg_list>
	pop	reg
	ENDM
	ENDM
